#include <mpi.h>
#include <stdio.h>

int main(int argc, char ** argv)
{
    int myrank, size;
    int numsend, numrecv;
    int next_rank, prev_rank;
    MPI_Status  status;

    MPI_Init(&argc, &argv);

    MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    if(myrank==0){numsend=33;}else numsend=66;
    numrecv=50;

    next_rank = myrank + 1;
    prev_rank = myrank - 1;
    if (next_rank > size-1) next_rank=0;
    if (prev_rank < 0 ) prev_rank=size-1;

    MPI_Sendrecv(&numsend,1,MPI_INT,
              next_rank,10,
             &numrecv,1,MPI_INT,
              prev_rank,10,
              MPI_COMM_WORLD, &status);

    //if(myrank==1){
    printf(" I am rank %d of %d Received value numrecv= %d\n", myrank, size, numrecv);

    MPI_Finalize();
    return 0;
}
