program fortran_mpi_alltoall
include 'mpif.h'
integer ierr
integer myrank, nprocs
integer numsend, numrecv
integer :: status(MPI_STATUS_SIZE) 
integer, dimension(:), allocatable :: asend, arecv

    call MPI_INIT ( ierr )
    !print *, "Hello world"

    call MPI_Comm_rank(MPI_COMM_WORLD, myrank, ierr);
    call MPI_Comm_size(MPI_COMM_WORLD, nprocs, ierr);
    !print *, "Hello World! I am rank ",myrank," of ", size

    allocate(asend(2*nprocs))
    allocate(arecv(2*nprocs))

    do i = 1,nprocs
      asend(2*i)=i+myrank*10
      asend(2*i-1)=-1*(i+myrank*10)
    end do
    !numsend=33
    !numrecv=50
  
    print*,'myrank=',myrank,'asend:',asend

    call MPI_AlltoAll(asend,2,MPI_INT, &
         arecv,2,MPI_INT, &
         MPI_COMM_WORLD,ierr)

    print*,'myrank=',myrank,'arecv:',arecv

    !if (myrank==1) then
    !print *," I am rank",myrank," of ", nprocs
    !print *,"Received value numrecv= ", numrecv
    !end if

    deallocate(asend, arecv)
call MPI_FINALIZE ( ierr )

end program fortran_mpi_alltoall
