#include <mpi.h>
#include <stdio.h>

int main(int argc, char ** argv)
{
    int myrank, size;

    int asend[8], arecv[8], sendcounts[4], sdispls[4];
//, sendcounts[4];
    int i;

    MPI_Status status;

    MPI_Init(&argc, &argv);


    MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    for (i=0;i<size;i++) {
       asend[2*i]=(i+1)+myrank*10;
       asend[2*i+1]=-1*((i+1)+myrank*10);
     }

    if (myrank==0) 
    {
       sendcounts[0]=1;
       sendcounts[1]=2;
       sendcounts[2]= 3;
       sendcounts[3]=2;
       sdispls[0]= 0;
       sdispls[1]= 1;
       sdispls[2]= 3;
       sdispls[3]= 6;
    }
    else if (myrank==1)
     {
       sendcounts[0]=2;
       sendcounts[1]=3;
       sendcounts[2]=2;
       sendcounts[3]=1;
       sdispls[0]= 0;
       sdispls[1]= 2;
       sdispls[2]= 5;
       sdispls[3]= 7;
    }
    else if (myrank==2)
     {
       sendcounts[0]=3;
       sendcounts[1]=2;
       sendcounts[2]=1;
       sendcounts[3]=2;
       sdispls[0]= 0;
       sdispls[1]= 3;
       sdispls[2]= 5;
       sdispls[3]= 6;
    }
    else if (myrank==3)
     {
       sendcounts[0]=2;
       sendcounts[1]=1;
       sendcounts[2]=2;
       sendcounts[3]=3;
       sdispls[0]= 0;
       sdispls[1]= 2;
       sdispls[2]= 3;
       sdispls[3]= 5;
    }

//      for (i=0;i<size;i++) 
//       printf("%d, ",sendcounts[i]);
//     }
    printf("Myrank=%d. asend= ",myrank);
    for (i=0;i<2*size;i++) {
       printf("%d, ",asend[i]);
       }
    printf("\n");


    MPI_Alltoallv(asend,sendcounts,sdispls, MPI_INT, 
                  arecv,sendcounts,sdispls, MPI_INT, 
         MPI_COMM_WORLD);

    printf("Myrank=%d. arecv= ",myrank);
    for (i=0;i<2*size;i++) {
       printf("%d, ",arecv[i]);
       }
    printf("\n");


    

    MPI_Finalize();
    return 0;
}
