#!/bin/sh
#PBS -N myjobname
#PBS -l select=1:ncpus=24 
#//select 1 compute nodes

#PBS -l walltime=00:01:00   
#//maximum walltime for a job to run

#PBS -q temp0
#PBS -l place=scatter
#PBS -l accelerator_type="None" 
#//add the above line only for idqueue,small,small72,medium queue

#PBS -S /bin/sh@sdb -V	
#PBS -j oe

. /opt/modules/default/init/sh
cd $PBS_O_WORKDIR

SERC_HOST=sahasrat
if [ $SERC_HOST = "sahasrat" ]; then
MODULE_SET=INTEL
#MODULE_SET=ADVISOR
#MODULE_SET=NONE
#MODULE_SET=ESDBinod_KNL_2019.01

MODULE_LIST_FILE="$HOME/usr/bash/modulelist.$SERC_HOST.$MODULE_SET"
if [ -f $MODULE_LIST_FILE ]; then
source $MODULE_LIST_FILE
export MODULE_LIST_FILE
fi

fi

export MPICH_MAX_THREAD_SAFETY=multiple

#Launch the parallel job
#aprun -j 1 -n 24 -N 24 ./a.out
aprun -j 1 -n 24 -N 24 ./a.out
#//Using 240 MPI processes and 24 MPI processes per node
