#include <mpi.h>
#include <stdio.h>

int main(int argc, char ** argv)
{
    int myrank, size;

    int asend[8], arecv[8];
    int i;

    MPI_Status status;

    MPI_Init(&argc, &argv);


    MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    for (i=0;i<size;i++) {
       asend[2*i]=(i+1)+myrank*10;
       asend[2*i+1]=-1*((i+1)+myrank*10);
     }

    printf("Myrank=%d. asend= ",myrank);
    for (i=0;i<2*size;i++) {
       printf("%d, ",asend[i]);
       }
    printf("\n");


    MPI_Alltoall(asend,2,MPI_INT, 
         arecv,2,MPI_INT, 
         MPI_COMM_WORLD);

    printf("Myrank=%d. arecv= ",myrank);
    for (i=0;i<2*size;i++) {
       printf("%d, ",arecv[i]);
       }
    printf("\n");

    MPI_Finalize();
    return 0;
}
