#include "mpi.h"
#include <stdio.h>
#include <math.h>
#define MAXSIZE 100

int main(int argc, char **argv)
{
	int myrank, numprocs;
	int data[MAXSIZE], i, x, low, high, myresult=0, result;
	char fn[255];
	FILE *fp;
        int provided;

	//MPI_Init(&argc, &argv);
	MPI_Init_thread(&argc, &argv, MPI_THREAD_MULTIPLE, &provided);
	MPI_Comm_size(MPI_COMM_WORLD, &numprocs);
	MPI_Comm_rank(MPI_COMM_WORLD, &myrank);
        if(0 == myrank) {
                printf("MPI_INIT_THREAD Support requested= %d provided = %d\n",MPI_THREAD_MULTIPLE, provided);
        }

        for ( i = 0; i < MAXSIZE;i++) {
         data[i]=i;
        }

	
	/* add portion of data */
	x = MAXSIZE/numprocs + 1;	/* must be an integer */
	low = myrank * x;
	high = low + x;
        if (high > MAXSIZE ) high=MAXSIZE-1;
	for(i=low; i<high; i++) {
		myresult += data[i];
	}
	printf("I got %d from %d\n", myresult, myrank);

	/* compute global sum */
	MPI_Reduce(&myresult, &result, 1, MPI_INT, MPI_SUM, 0, MPI_COMM_WORLD);

	if(0 == myrank) {
		printf("The sum is %d.\n", result);
	}

	MPI_Finalize();
}

	
