#include "mpi.h"
#include <stdio.h>
#include <math.h>

int main( int argc, char *argv[] )
{

    int n, myid, numprocs, i, j, tag, my_n;
    double PI25DT = 3.141592653589793238462643;
    double mypi,pi,h,sum,x,pi_frac,tt0,tt1,ttf;
    FILE *ifp;
    MPI_Status  Stat;
    MPI_Request request;

    n = 1;
    tag = 1;

    MPI_Init(&argc,&argv);
    MPI_Comm_size(MPI_COMM_WORLD,&numprocs);
    MPI_Comm_rank(MPI_COMM_WORLD,&myid);


    tt0 = MPI_Wtime();
    if (myid == 0) {

       ifp = fopen("ex4.in","r");

       fscanf(ifp,"%d",&n);

       fclose(ifp);
       printf("number of intervals = %d\n",n);
    }

 /* Global communication. Process 0 "broadcasts" n to all other processes */

    MPI_Bcast(&n, 1, MPI_INT, 0, MPI_COMM_WORLD);
    h   = 1.0 / (double) n;
    sum = 0.0;

    for (i = myid*n/numprocs+1; i <= (myid+1)*n/numprocs; i++) {
        x = h * ((double)i - 0.5);
        sum += (4.0 / (1.0 + x*x));
    }

    mypi = h * sum;
    pi = 0.;  /* It is not necessary to set pi = 0 */


 /* Global reduction. All processes send their value of mypi to process 0

    and process 0 adds them up (MPI_SUM) */
    MPI_Reduce(&mypi, &pi, 1, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD);

    ttf = MPI_Wtime();

    printf("myid=%d  pi is approximately %.16f, Error is %.16f  time = %10f\n",

               myid, pi, fabs(pi - PI25DT), (ttf-tt0));


    MPI_Finalize();

    return 0;

}
